Rem  Copyright (c) 1998 by Oracle Corporation 
Rem    NAME
Rem     ExcelSolution.sql - APIs to enables Oracle callouts to Excel Automation Server
Rem    DESCRIPTION
REM Demonstrate Oracle Database callouts using the COMCartridge to Excel spreadsheet
REM		Expose a set of calls to
REM		1. create an Excel Worksheet
REM		2. Insert Data into specified cells
REM		3. Insert chart into an area of the Spreadsheet
REM		4. Save the Excel spreadsheet
REM		5. Quit Excel
REM
Rem    MODIFIED   (MM/DD/YY)
Rem     kfleong	   01/05/98 -  Creation
REM
REM	
set serveroutput on;
drop package ORDExcel; 
/
CREATE PACKAGE ORDExcel AS


   /* Declare externally callable subprograms. */
   
   FUNCTION CreateExcelWorkSheet(servername varchar2) return binary_integer;

   FUNCTION InsertData(range varchar2, data binary_integer, type varchar2) return binary_integer;

   FUNCTION InsertDataReal(range varchar2, data double precision, type varchar2) return binary_integer;

   FUNCTION GetDataNum(range varchar2) return binary_integer;

   FUNCTION GetDataStr(range varchar2) return varchar2;

   FUNCTION GetDataReal(range varchar2) return double precision;

   FUNCTION GetDataDate(range varchar2) return date;
	
   FUNCTION InsertData(range varchar2, data varchar2, type varchar2) return binary_integer;

   FUNCTION InsertData(range varchar2, data Date, type varchar2) return binary_integer;

   FUNCTION InsertChart(xpos binary_integer, ypos binary_integer, width binary_integer, 
						height binary_integer, range varchar2, type varchar2) return binary_integer;


   FUNCTION SaveExcelFile(filename varchar2) return binary_integer;
   
   FUNCTION ExitExcel return binary_integer;

END ORDExcel;

/
CREATE PACKAGE BODY ORDExcel AS

   DummyToken		binary_integer;	
   applicationToken binary_integer:=-1;
   WorkBooksToken	binary_integer:=-1;
   WorkBookToken	binary_integer:=-1;
   WorkSheetToken	binary_integer:=-1;
   WorkSheetToken1	binary_integer:=-1;
   RangeToken		binary_integer:=-1;
   ChartObjectToken	binary_integer:=-1;
   ChartObject1		binary_integer:=-1;
   Chart1Token		binary_integer:=-1;
   i				binary_integer;
   retNum			binary_integer;
   retReal			double precision;
   retStr			varchar2(255);
   retDate			DATE;
error_src varchar2(255);
error_description varchar2(255);
error_helpfile varchar2(255);
error_helpID binary_integer;

/***************************************************************************
 * Invoke the Excel Automation Server and create a Workbook object as 
 * well as a worksheet object
 ***************************************************************************/
FUNCTION CreateExcelWorkSheet(servername varchar2) return binary_integer IS
BEGIN
	dbms_output.put_line('Creating Excel application...');
	i:=ORDCOM.CreateObject('Excel.Application', 0, servername,applicationToken);
	IF (i!=0) THEN
	ORDCOM.GetLastError(error_src, error_description, error_helpfile, error_helpID);
	dbms_output.put_line(error_src);
	dbms_output.put_line(error_description);
	dbms_output.put_line(error_helpfile);
	END IF;
	dbms_output.put_line('Invoking Workbooks...');
	/*i:=ORDCOM.Invoke(applicationToken, 'WorkBooks',0, WorkBooksToken);*/
	i:=ORDCOM.GetProperty(applicationToken, 'WorkBooks', 0, WorkBooksToken);
	IF (i!=0) THEN
	ORDCOM.GetLastError(error_src, error_description, error_helpfile, error_helpID);
	dbms_output.put_line(error_src);
	dbms_output.put_line(error_description);
	dbms_output.put_line(error_helpfile);
	END IF;
	dbms_output.put_line('Invoking Add to WorkBooks...');
	ORDCOM.InitArg();
	ORDCOM.SetArg(-4167,'I4');
	i:=ORDCOM.Invoke(WorkBooksToken, 'Add', 1, WorkBookToken);
IF (i!=0) THEN
	ORDCOM.GetLastError(error_src, error_description, error_helpfile, error_helpID);
	dbms_output.put_line(error_src);
	dbms_output.put_line(error_description);
	dbms_output.put_line(error_helpfile);
	END IF;

	dbms_output.put_line('Invoking WorkSheets..');
	ORDCOM.InitArg();
	ORDCOM.SetArg('Sheet 1','BSTR');

/*	i:=ORDCOM.Invoke(applicationToken, 'WorkSheets', 1, WorkSheetToken);*/
i:=ORDCOM.GetProperty(applicationToken, 'WorkSheets', 0, WorkSheetToken1);
IF (i!=0) THEN
	ORDCOM.GetLastError(error_src, error_description, error_helpfile, error_helpID);
	dbms_output.put_line(error_src);
	dbms_output.put_line(error_description);
	dbms_output.put_line(error_helpfile);
	END IF;
i:=ORDCOM.Invoke(WorkSheetToken1, 'Add', 0, WorkSheetToken);
IF (i!=0) THEN
	ORDCOM.GetLastError(error_src, error_description, error_helpfile, error_helpID);
	dbms_output.put_line(error_src);
	dbms_output.put_line(error_description);
	dbms_output.put_line(error_helpfile);
	END IF;

	return i;
END CreateExcelWorkSheet;


/***************************************************************************
 * Invoke the Range method to obtain a range token. Then set the property value
 * at the specified range to the data required
 ***************************************************************************/
FUNCTION InsertData( range varchar2,
					data binary_integer,
					type varchar2) 
					RETURN binary_integer IS
BEGIN

	ORDCOM.InitArg();
	ORDCOM.SetArg(range, 'BSTR');
	i:=ORDCOM.GetProperty(WorkSheetToken, 'Range', 1, RangeToken);

	IF (i!=0) THEN
	ORDCOM.GetLastError(error_src, error_description, error_helpfile, error_helpID);
	dbms_output.put_line(error_src);
	dbms_output.put_line(error_description);
	dbms_output.put_line(error_helpfile);
	END IF;
	i:=ORDCOM.SetProperty(RangeToken, 'Value', data, type);
/*
	IF (i!=0) THEN
	ORDCOM.GetLastError(error_src, error_description, error_helpfile, error_helpID);
	dbms_output.put_line(error_src);
	dbms_output.put_line(error_description);
	dbms_output.put_line(error_helpfile);
	END IF;*/
	i:=ORDCOM.DestroyObject(RangeToken);
	RETURN i;
END InsertData;

/***************************************************************************
 * Invoke the Range method to obtain a range token. Then set the property value
 * at the specified range to the data required
 ***************************************************************************/
FUNCTION GetDataNum( range varchar2) 
					RETURN binary_integer IS
BEGIN

	ORDCOM.InitArg();
	ORDCOM.SetArg(range, 'BSTR');
	i:=ORDCOM.GetProperty(WorkSheetToken, 'Range', 1, RangeToken);

	IF (i!=0) THEN
	ORDCOM.GetLastError(error_src, error_description, error_helpfile, error_helpID);
	dbms_output.put_line(error_src);
	dbms_output.put_line(error_description);
	dbms_output.put_line(error_helpfile);
	END IF;
	i:=ORDCOM.GetProperty(RangeToken, 'Value', 0, retNum);
	IF (i!=0) THEN
	ORDCOM.GetLastError(error_src, error_description, error_helpfile, error_helpID);
	dbms_output.put_line(error_src);
	dbms_output.put_line(error_description);
	dbms_output.put_line(error_helpfile);
	END IF;
	i:=ORDCOM.DestroyObject(RangeToken);
	RETURN retNum;
END GetDataNum;

FUNCTION GetDataReal( range varchar2) 
					RETURN double precision IS
BEGIN

	ORDCOM.InitArg();
	ORDCOM.SetArg(range, 'BSTR');
	i:=ORDCOM.GetProperty(WorkSheetToken, 'Range', 1, RangeToken);

	IF (i!=0) THEN
	ORDCOM.GetLastError(error_src, error_description, error_helpfile, error_helpID);
	dbms_output.put_line(error_src);
	dbms_output.put_line(error_description);
	dbms_output.put_line(error_helpfile);
	END IF;
	i:=ORDCOM.GetProperty(RangeToken, 'Value', 0, retReal);
	IF (i!=0) THEN
	ORDCOM.GetLastError(error_src, error_description, error_helpfile, error_helpID);
	dbms_output.put_line(error_src);
	dbms_output.put_line(error_description);
	dbms_output.put_line(error_helpfile);
	END IF;
	i:=ORDCOM.DestroyObject(RangeToken);
	RETURN retReal;
END GetDataReal;

FUNCTION GetDataStr( range varchar2) 
					RETURN varchar2 IS
BEGIN
	ORDCOM.InitArg();
	ORDCOM.SetArg(range, 'BSTR');
	i:=ORDCOM.GetProperty(WorkSheetToken, 'Range', 1, RangeToken);
	IF (i!=0) THEN
	ORDCOM.GetLastError(error_src, error_description, error_helpfile, error_helpID);
	dbms_output.put_line(error_src);
	dbms_output.put_line(error_description);
	dbms_output.put_line(error_helpfile);
	END IF;
	i:=ORDCOM.GetProperty(RangeToken, 'Value', 0, retStr);
	IF (i!=0) THEN
	ORDCOM.GetLastError(error_src, error_description, error_helpfile, error_helpID);
	dbms_output.put_line(error_src);
	dbms_output.put_line(error_description);
	dbms_output.put_line(error_helpfile);
	END IF;
	i:=ORDCOM.DestroyObject(RangeToken);
	RETURN retStr;
END GetDataStr;

FUNCTION GetDataDate( range varchar2) 
					RETURN Date IS
BEGIN
	ORDCOM.InitArg();
	ORDCOM.SetArg(range, 'BSTR');
	i:=ORDCOM.GetProperty(WorkSheetToken, 'Range', 1, RangeToken);
	IF (i!=0) THEN
	ORDCOM.GetLastError(error_src, error_description, error_helpfile, error_helpID);
	dbms_output.put_line(error_src);
	dbms_output.put_line(error_description);
	dbms_output.put_line(error_helpfile);
	END IF;
	i:=ORDCOM.GetProperty(RangeToken, 'Value', 0, retDate);
	IF (i!=0) THEN
	ORDCOM.GetLastError(error_src, error_description, error_helpfile, error_helpID);
	dbms_output.put_line(error_src);
	dbms_output.put_line(error_description);
	dbms_output.put_line(error_helpfile);
	END IF;
	i:=ORDCOM.DestroyObject(RangeToken);
	RETURN retDate;
END GetDataDate;

FUNCTION InsertData( range varchar2,
					data DATE,
					type varchar2) 
					RETURN binary_integer IS
BEGIN

	ORDCOM.InitArg();
	ORDCOM.SetArg(range, 'BSTR');
	i:=ORDCOM.GetProperty(WorkSheetToken, 'Range', 1, RangeToken);
	i:=ORDCOM.SetProperty(RangeToken, 'Value', data, type);
	i:=ORDCOM.DestroyObject(RangeToken);
	RETURN i;
END InsertData;

FUNCTION InsertDataReal( range varchar2,
					data double precision,
					type varchar2) 
					RETURN binary_integer IS
BEGIN

	ORDCOM.InitArg();
	ORDCOM.SetArg(range, 'BSTR');
	i:=ORDCOM.GetProperty(WorkSheetToken, 'Range', 1, RangeToken);
	i:=ORDCOM.SetProperty(RangeToken, 'Value', data, type);
	i:=ORDCOM.DestroyObject(RangeToken);
	RETURN i;
END InsertDataReal;

FUNCTION InsertData( range varchar2,
					data varchar2,
					type varchar2) 
					RETURN binary_integer IS
BEGIN

	ORDCOM.InitArg();
	ORDCOM.SetArg(range, 'BSTR');
	i:=ORDCOM.GetProperty(WorkSheetToken, 'Range', 1, RangeToken);
	i:=ORDCOM.SetProperty(RangeToken, 'Value', data, type);
	i:=ORDCOM.DestroyObject(RangeToken);
	RETURN i;
END InsertData;

/******************************************************************************
 * Insert a chart at the x and y position of the spreadsheet with the desired
 * height and width. Then also uses the ChartWizard to draw the graph with data
 * in a specified range area with a specified charting type.
 *******************************************************************************/
FUNCTION InsertChart(xpos binary_integer, ypos binary_integer, 
					 width binary_integer, height binary_integer, 
					 range varchar2, type varchar2) RETURN binary_integer IS
	charttype binary_integer:= -4099;
BEGIN
	ORDCOM.InitArg();
	i:=ORDCOM.GetProperty(WorkSheetToken, 'ChartObjects', 0, ChartObjectToken);
	IF (i!=0) THEN
	ORDCOM.GetLastError(error_src, error_description, error_helpfile, error_helpID);
	dbms_output.put_line(error_src);
	dbms_output.put_line(error_description);
	dbms_output.put_line(error_helpfile);
	END IF;

	ORDCOM.InitArg();
	ORDCOM.SetArg(xpos,'I2');
	ORDCOM.SetArg(ypos,'I2');
	ORDCOM.SetArg(width,'I2');
	ORDCOM.SetArg(height,'I2');
	i:=ORDCOM.Invoke(ChartObjectToken, 'Add', 4, ChartObject1);
	IF (i!=0) THEN
	ORDCOM.GetLastError(error_src, error_description, error_helpfile, error_helpID);
	dbms_output.put_line(error_src);
	dbms_output.put_line(error_description);
	dbms_output.put_line(error_helpfile);
	END IF;

	i:=ORDCOM.GetProperty(ChartObject1, 'Chart', 0,Chart1Token);
	ORDCOM.InitArg();
	ORDCOM.SetArg(range, 'BSTR');
	i:=ORDCOM.GetProperty(WorkSheetToken,'Range', 1, RangeToken);
	ORDCOM.InitArg();
	ORDCOM.SetArg(RangeToken, 'DISPATCH');
	IF type='xlPie' THEN
		charttype := -4102;
	ELSIF type='xl3DBar' THEN
		charttype := -4099;
	ELSIF type='xlBar' THEN
		charttype := 2;
	ELSIF type='xl3dLine' THEN
		charttype:= -4101;
	END IF;
	ORDCOM.SetArg(charttype,'I4');
	i:=ORDCOM.Invoke(Chart1Token,'ChartWizard', 2, DummyToken);
	i:=ORDCOM.DestroyObject(RangeToken);
	i:=ORDCOM.DestroyObject(ChartObjectToken);
	i:=ORDCOM.DestroyObject(ChartObject1);
	i:=ORDCOM.DestroyObject(Chart1Token);
	RETURN i;
END InsertChart;

/******************************************************************************
 * Save the Excel File. WARNING: Do not specify a filename that already exist
 * since there is no graphical context, Oracle would not be able to pop
 * out a warning message for existing file. This causes Excel to hang
 *******************************************************************************/
FUNCTION SaveExcelFile(filename varchar2) return binary_integer IS
BEGIN
	dbms_output.put_line('Saving Excel file...');
	ORDCOM.InitArg();
	ORDCOM.SetArg(filename,'BSTR');

	i:=ORDCOM.Invoke(WorkBookToken, 'SaveAs', 1, DummyToken);
	IF (i!=0) THEN
	ORDCOM.GetLastError(error_src, error_description, error_helpfile, error_helpID);
	dbms_output.put_line(error_src);
	dbms_output.put_line(error_description);
	dbms_output.put_line(error_helpfile);
	END IF;

	RETURN i;	
END SaveExcelFile;

/******************************************************************************
 * Close the Excel spreadsheet and exit from it
 ******************************************************************************/
FUNCTION ExitExcel return binary_integer is
BEGIN
	dbms_output.put_line('Closing workbook and quitting...');
	ORDCOM.InitArg();
	
	ORDCOM.InitArg();
	ORDCOM.SetArg(FALSE,'BOOL');
	dbms_output.put_line('Closing workbook...');
	i:=ORDCOM.Invoke(WorkBookToken, 'Close', 0, DummyToken);
	IF (i!=0) THEN
	ORDCOM.GetLastError(error_src, error_description, error_helpfile, error_helpID);
	dbms_output.put_line(error_src);
	dbms_output.put_line(error_description);
	dbms_output.put_line(error_helpfile);
	END IF;
	i:=ORDCOM.DestroyObject(WorkBookToken);	
	ORDCOM.InitArg();
	dbms_output.put_line('Closing workbooks...');
	i:=ORDCOM.Invoke(WorkBooksToken, 'Close', 0, DummyToken);
	IF (i!=0) THEN
	ORDCOM.GetLastError(error_src, error_description, error_helpfile, error_helpID);
	dbms_output.put_line(error_src);
	dbms_output.put_line(error_description);
	dbms_output.put_line(error_helpfile);
	END IF;
	i:=ORDCOM.DestroyObject(WorkBooksToken);
	i:=ORDCOM.Invoke(applicationToken, 'Quit', 0, DummyToken);
	IF (i!=0) THEN
	ORDCOM.GetLastError(error_src, error_description, error_helpfile, error_helpID);
	dbms_output.put_line(error_src);
	dbms_output.put_line(error_description);
	dbms_output.put_line(error_helpfile);
	END IF;

	i:=ORDCOM.DestroyObject(WorkSheetToken);	
	i:=ORDCOM.DestroyObject(WorkSheetToken1);	


	i:=ORDCOM.DestroyObject(applicationToken);
	i:=ORDCOM.DestroyObject(ChartObjectToken);
	i:=ORDCOM.DestroyObject(Chart1Token);
	i:=ORDCOM.DestroyObject(ChartObject1);
	i:=ORDCOM.DestroyObject(dummyToken);
	RETURN i;
END ExitExcel;


END ORDExcel;